/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWTableDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import java.io.Serializable;

public final class VWQueueDefinition
extends VWTableDefinition
implements Serializable,
IVWTableDefinition,
Cloneable,
IVWtoXML {
    private static final long serialVersionUID = 119049L;
    private static final int MIN_QUEUE_TYPE = 1;
    public static final int QUEUE_TYPE_PROCESS = 1;
    public static final int QUEUE_TYPE_USER_CENTRIC = 2;
    public static final int QUEUE_TYPE_SYSTEM = 3;
    private static final int MAX_QUEUE_TYPE = 3;
    public static final int QUEUE_ON_ALL_SERVERS = -1;
    protected int queueType;
    protected boolean isConnectorQueue = false;
    protected transient VWSystemConfiguration sysConfig = null;
    protected String logicalName = null;
    protected VWOperationDefinition[] operations = null;
    protected VWArrayHandler operationsHandler = new VWArrayHandler();
    private VWWorkBasketDefinition[] m_workBasketDefs = new VWWorkBasketDefinition[0];
    private VWArrayHandler m_workBasketDefHandler = new VWArrayHandler();
    private VWWorkBasketDefinition[] m_deletedWorkBasketDefs = new VWWorkBasketDefinition[0];
    private VWArrayHandler m_deletedWorkBasketDefHandler = new VWArrayHandler();
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWQueueTypeProcess", "Process").toString(), new VWString("VW.api.VWQueueTypeUserCentric", "User-centric").toString(), new VWString("VW.api.VWQueueTypeSystem", "System").toString()};

    public static String _get_FILE_DATE() {
        return "$Date: 2011-01-19 23:56:43 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    protected VWQueueDefinition(String theName, int theType) throws VWException {
        super(theName, 2);
        this.queueType = theType;
        this.logicalName = theName;
    }

    public VWExposedFieldDefinition createFieldDefinition(String theName, int theType, int theLength) throws VWException {
        return super.createFieldDefinition(theName, theType, theLength);
    }

    public void deleteFieldDefinition(String theName) throws VWException {
        VWWorkBasketDefinition[] workBasketDefs;
        if (theName != null && theName.trim().length() > 0 && this.m_workBasketDefs != null && this.m_workBasketDefs.length > 0 && (workBasketDefs = this.getWorkBasketDefinitions()) != null) {
            VWExposedFieldDefinition fieldDef = null;
            for (int i = 0; i < workBasketDefs.length; ++i) {
                VWWorkBasketColumnDefinition[] wbColumnDefs;
                if (workBasketDefs[i] == null) continue;
                VWWorkBasketFilterDefinition[] wbFilterDefs = workBasketDefs[i].getWorkBasketFilterDefinitions();
                if (wbFilterDefs != null) {
                    for (int j = 0; j < wbFilterDefs.length; ++j) {
                        if (wbFilterDefs[j] == null || (fieldDef = wbFilterDefs[j].getSearchField()) == null || !fieldDef.name.equals(theName)) continue;
                        throw new VWException("vw.api.VWQueueDefinitionCantDeleteFiledUsedByWBFilter", "Failed to delete exposed field \"{0}\" - it is being used by Inbasket filter \"{1}\" from Inbasket \"{2}\".", theName, wbFilterDefs[j].getName(), this.m_workBasketDefs[i].getName());
                    }
                }
                if ((wbColumnDefs = workBasketDefs[i].getWorkBasketColumnDefinitions()) == null) continue;
                for (int j = 0; j < wbColumnDefs.length; ++j) {
                    if (wbColumnDefs[j] == null || (fieldDef = wbColumnDefs[j].getColumn()) == null || !fieldDef.name.equals(theName)) continue;
                    throw new VWException("vw.api.VWQueueDefinitionCantDeleteFiledUsedByWBColumn", "Failed to delete exposed field \"{0}\" - it is being used by Inbasket column \"{1}\" from Inbasket \"{2}\".", theName, wbColumnDefs[j].getName(), this.m_workBasketDefs[i].getName());
                }
            }
        }
        super.deleteFieldDefinition(theName);
    }

    public void createFieldDefinitions(VWExposedFieldDefinition[] theDefs) throws VWException {
        super.createFieldDefinitions(theDefs);
    }

    public VWIndexDefinition createIndexDefinition(String theName, String[] theFieldNames) throws VWException {
        return super.createIndexDefinition(theName, theFieldNames, false, this);
    }

    protected VWIndexDefinition createIndexDefinition(String theName, String[] theFieldNames, boolean systemIndex) throws VWException {
        return super.createIndexDefinition(theName, theFieldNames, systemIndex, this);
    }

    public void deleteIndexDefinition(String theName) throws VWException {
        VWWorkBasketDefinition[] workBasketDefs;
        if (theName != null && theName.trim().length() > 0 && this.m_workBasketDefs != null && this.m_workBasketDefs.length > 0 && (workBasketDefs = this.getWorkBasketDefinitions()) != null) {
            for (int i = 0; i < workBasketDefs.length; ++i) {
                if (workBasketDefs[i] == null || !theName.trim().equals(workBasketDefs[i].getIndexName())) continue;
                throw new VWException("vw.api.VWQueueDefinitionCantDeleteUsedIndex", "Failed to delete index \"{0}\" - it is being used by Inbasket \"{1}\".", theName, this.m_workBasketDefs[i].getName());
            }
        }
        super.deleteIndexDefinition(theName);
    }

    public void createIndexDefinitions(VWIndexDefinition[] theDefs) throws VWException {
        super.createIndexDefinitions(theDefs);
    }

    public VWExposedFieldDefinition getField(String name) throws VWException {
        return super.getExposedField(name);
    }

    public VWOperationDefinition[] getOperations() throws VWException {
        return (VWOperationDefinition[])this.operationsHandler.getElements(this.operations);
    }

    public VWOperationDefinition getOperation(String theName) throws VWException {
        int i = this.operationsHandler.getIndexFromStringFieldValue(this.operations, "name", theName);
        if (i == -1) {
            throw new VWException("vw.api.VWQueueDefinitionOperationNotFound", "No operation found with name equal to {0} in this queue definition.", theName);
        }
        return this.operations[i];
    }

    public void deleteOperation(String theName) throws VWException {
        if (theName == null) {
            throw new VWException("vw.api.VWQueueDefOpNameBad", "Operation name parameter is null.");
        }
        int i = this.operationsHandler.getIndexFromStringFieldValue(this.operations, "name", theName);
        if (i == -1) {
            throw new VWException("vw.api.VWQueueDefOperationNameNotFound", "operation name not found. Operation names are case sensitive. Check spelling and case.{0}", theName);
        }
        this.operationsHandler.deleteElementFromArray(this.operations, i);
        this.bHasChanged = true;
    }

    public VWOperationDefinition createOperation(String theName) throws VWException {
        if (this.operationsHandler.getIndexFromStringFieldValue(this.operations, "name", theName) != -1) {
            throw new VWException("vw.api.VWQueueDefOpAlreadyExists", "Attempt to create an operation named {0}, an operation of that name already exists.", theName);
        }
        VWOperationDefinition newOp = new VWOperationDefinition(this, theName);
        this.operations = (VWOperationDefinition[])this.operationsHandler.addElementToArray(this.operations, newOp);
        this.bHasChanged = true;
        return newOp;
    }

    protected void createOperations(VWOperationDefinition[] theOps) throws VWException {
        for (int i = 0; i < theOps.length; ++i) {
            if (theOps[i] != null) continue;
            throw new VWException("vw.api.VWQueueDefNullOpInArray", "The Array of Operation Definitions contains a null at index: {0}", String.valueOf(i));
        }
        this.operations = theOps;
        this.operationsHandler.setElementCount(theOps.length);
        this.bHasChanged = false;
    }

    public VWWorkBasketDefinition getWorkBasketDefinition(String workBasketName) throws VWException {
        if (workBasketName == null || workBasketName.trim().length() == 0) {
            throw new VWException("vw.api.VWQueueDefinition.getWBDefWithNullName", "Cannot get an Inbasket definition with a null or empty name");
        }
        VWWorkBasketDefinition[] wbDefs = this.getWorkBasketDefinitions();
        VWWorkBasketDefinition result = null;
        String tmpdefName = null;
        String tmpdefAuthoredName = null;
        if (wbDefs != null) {
            for (int i = 0; i < wbDefs.length; ++i) {
                if (wbDefs[i] == null) continue;
                tmpdefName = wbDefs[i].getName();
                tmpdefAuthoredName = wbDefs[i].getAuthoredName();
                if ((tmpdefName == null || !workBasketName.equals(tmpdefName)) && (tmpdefAuthoredName == null || !workBasketName.equals(tmpdefAuthoredName))) continue;
                result = wbDefs[i];
                break;
            }
        }
        return result;
    }

    public VWWorkBasketDefinition[] getWorkBasketDefinitions() throws VWException {
        if (this.m_workBasketDefHandler.getElementCount() > 0) {
            this.m_workBasketDefs = (VWWorkBasketDefinition[])this.m_workBasketDefHandler.getElements(this.m_workBasketDefs);
            if (this.m_workBasketDefs != null) {
                VWWorkBasketDefinition[] workBasketDefs = new VWWorkBasketDefinition[this.m_workBasketDefs.length];
                System.arraycopy(this.m_workBasketDefs, 0, workBasketDefs, 0, this.m_workBasketDefs.length);
                return workBasketDefs;
            }
        }
        return null;
    }

    public VWWorkBasketDefinition createWorkBasketDefinition(String workBasketName) throws VWException {
        return this.createWorkBasketDefinition(workBasketName, 0);
    }

    protected VWWorkBasketDefinition createWorkBasketDefinition(String workBasketName, int revision) throws VWException {
        if (workBasketName == null || workBasketName.trim().length() == 0) {
            throw new VWException("vw.api.VWQueueDefinition.createWBDefWithNullName", "Cannot create an Inbasket definition with a null or empty name");
        }
        int nIndex = this.m_workBasketDefHandler.getIndexFromStringFieldValue(this.m_workBasketDefs, "m_name", workBasketName);
        if (nIndex != -1) {
            throw new VWException("vw.api.VWQueueDefinition.workbasketAlreadyExists", "A Inbasket definition with that name already exists - {0} ", workBasketName);
        }
        VWWorkBasketDefinition newWorkBasketDef = new VWWorkBasketDefinition(revision, workBasketName, this);
        this.m_workBasketDefs = (VWWorkBasketDefinition[])this.m_workBasketDefHandler.addElementToArray(this.m_workBasketDefs, newWorkBasketDef);
        this.bHasChanged = true;
        return newWorkBasketDef;
    }

    protected void addWorkBasketDefinition(VWWorkBasketDefinition wbDef) throws VWException {
        if (wbDef == null) {
            throw new VWException("vw.api.VWQueueDefinition.addWBDefWithNullName", "Cannot add a null Inbasket definition");
        }
        int nIndex = this.m_workBasketDefHandler.getIndexFromStringFieldValue(this.m_workBasketDefs, "m_name", wbDef.getName());
        if (nIndex != -1) {
            throw new VWException("vw.api.VWQueueDefinition.workbasketAlreadyExists", "A Inbasket definition with that name already exists - {0}.", wbDef.getName());
        }
        this.m_workBasketDefs = (VWWorkBasketDefinition[])this.m_workBasketDefHandler.addElementToArray(this.m_workBasketDefs, wbDef);
        this.bHasChanged = true;
    }

    public VWWorkBasketDefinition deleteWorkBasketDefinition(String workBasketName) throws VWException {
        if (workBasketName == null || workBasketName.trim().length() == 0) {
            throw new VWException("vw.api.VWQueueDefinition.WorkBasketDeleteWithNullName", "Cannot delete an Inbasket with a null or empty name");
        }
        int nIndex = this.m_workBasketDefHandler.getIndexFromStringFieldValue(this.m_workBasketDefs, "m_name", workBasketName);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWQueueDefinition.WorkBasketNotFound", "No Inbasket found with name equal to \"{0}\".", workBasketName);
        }
        VWWorkBasketDefinition workbasketDef = this.m_workBasketDefs[nIndex];
        if (this.sysConfig == null) {
            throw new VWException("vw.api.VWQueueDefinition.NeedSysConfgOjbToDeleteWorkBasket", "Cannot delete a Inbasket - the VWSystemConfiguration object can not be null");
        }
        VWApplicationSpaceDefinition[] asDefs = this.sysConfig.getApplicationSpaceDefinitions();
        if (asDefs != null) {
            for (int i = 0; i < asDefs.length; ++i) {
                VWRoleDefinition[] roleDefs;
                if (asDefs[i] == null || (roleDefs = asDefs[i].getRoleDefinitions()) == null) continue;
                for (int j = 0; j < roleDefs.length; ++j) {
                    VWWorkBasketDefinition[] wbDefs;
                    if (roleDefs[j] == null || (wbDefs = roleDefs[j].getWorkBasketDefinitions()) == null) continue;
                    for (int k = 0; k < wbDefs.length; ++k) {
                        if (wbDefs[k] == null || wbDefs[k].getName() == null || !wbDefs[k].getName().equals(workBasketName) || wbDefs[k].getQueueName() == null || !wbDefs[k].getQueueName().equals(this.getName())) continue;
                        throw new VWException("vw.api.VWQueueDefinitionCantDeleteWBUsedByRoleDef", "Failed to delete Inbasket \"{0}\" - it is being used by role \"{1}\" from application space \"{2}\".", workBasketName, roleDefs[j].getName(), asDefs[i].getName());
                    }
                }
            }
        }
        this.m_workBasketDefHandler.deleteElementFromArray(this.m_workBasketDefs, nIndex);
        if (workbasketDef.getObjId() != 0) {
            this.m_deletedWorkBasketDefs = (VWWorkBasketDefinition[])this.m_deletedWorkBasketDefHandler.addElementToArray(this.m_deletedWorkBasketDefs, workbasketDef);
        } else {
            workbasketDef.removeReferences();
        }
        this.bHasChanged = true;
        return workbasketDef;
    }

    protected VWWorkBasketDefinition[] getDeletedWorkBasketDefinitions() throws VWException {
        if (this.m_deletedWorkBasketDefHandler.getElementCount() > 0) {
            return (VWWorkBasketDefinition[])this.m_deletedWorkBasketDefHandler.getElements(this.m_deletedWorkBasketDefs);
        }
        return null;
    }

    public VWWorkBasketDefinition createCopyOfWorkBasketDefinition(String workBasketName, VWWorkBasketDefinition origWorkBasketDef) throws VWException {
        if (workBasketName == null || workBasketName.trim().length() == 0) {
            throw new VWException("vw.api.VWQueueDefinition.createCopyOfWorkBasketWithNullName", "The destination Inbasket name can not be null or empty");
        }
        if (origWorkBasketDef == null) {
            throw new VWException("vw.api.VWQueueDefinition.NullSourceWorkBasketDefinition", "The source Inbasket definition is null.");
        }
        VWWorkBasketDefinition newWorkBasketDef = (VWWorkBasketDefinition)origWorkBasketDef.clone();
        if (newWorkBasketDef != null) {
            newWorkBasketDef.m_nRevision = 0;
            newWorkBasketDef.m_nObjId = 0;
            newWorkBasketDef.setName(workBasketName);
            this.m_workBasketDefs = (VWWorkBasketDefinition[])this.m_workBasketDefHandler.addElementToArray(this.m_workBasketDefs, newWorkBasketDef);
        }
        this.bHasChanged = true;
        return newWorkBasketDef;
    }

    public VWIndexDefinition getIndex(String name) throws VWException {
        return super.getIndex(name);
    }

    public String getName() {
        return this.name;
    }

    protected String getLogicalName() {
        return this.logicalName;
    }

    protected void setLogicalName(String theLogicalName) {
        this.logicalName = theLogicalName;
        this.bHasChanged = true;
    }

    public int getQueueType() {
        return this.queueType;
    }

    public String[] getReadSecurity() {
        return super.getReadSecurity();
    }

    public VWParticipant[] getReadSecurityPx() throws VWException {
        return super.getReadSecurityPx();
    }

    public void setReadSecurity(String[] theNames) throws VWException {
        super.setReadSecurity(theNames);
    }

    public void setReadSecurityPx(VWParticipant[] thePxList) throws VWException {
        super.setReadSecurityPx(thePxList);
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setServerId(int theNewServerId) throws VWException {
        if (theNewServerId == -1) {
            throw new VWException("vw.api.VWQDefAllServersErr", "Can not set the server id to be all servers.");
        }
        super.setServerId(theNewServerId);
    }

    protected void internalSetServerId(int theNewServerId) {
        this.serverId = theNewServerId;
        this.bHasChanged = true;
    }

    public String[] getWriteSecurity() {
        return super.getWriteSecurity();
    }

    public VWParticipant[] getWriteSecurityPx() throws VWException {
        return super.getWriteSecurityPx();
    }

    public void setWriteSecurity(String[] theNames) throws VWException {
        super.setWriteSecurity(theNames);
    }

    public void setWriteSecurityPx(VWParticipant[] thePxList) throws VWException {
        super.setWriteSecurityPx(thePxList);
    }

    public String getDescription() {
        return super.getDescription();
    }

    public void setDescription(String theDescription) {
        super.setDescription(theDescription);
    }

    public String toString() {
        return super.toString();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (!this.isSelectedForExport) {
            return;
        }
        if (theBuffer == null) {
            throw new VWException("vw.api.VWQueueDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        theBuffer.append(INDENT_0 + "<" + "QueueDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(super.getDescription()) + "\"\n");
        theBuffer.append(INDENT_1 + "Type" + "=\"" + this.queueType + "\"\n");
        int nServerId = this.getServerId();
        if (nServerId >= 0) {
            theBuffer.append(INDENT_1 + "ServerId" + "=\"" + nServerId + "\"");
        }
        theBuffer.append(INDENT_1 + "IsConnectorQueue" + "=\"" + this.isConnectorQueue + "\"");
        theBuffer.append(">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfExposedFieldDefinition" + ">\n");
        VWExposedFieldDefinition[] fieldList = this.getFields();
        if (fieldList != null && fieldList.length > 0) {
            for (int i = 0; i < fieldList.length; ++i) {
                fieldList[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfExposedFieldDefinition" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfInBasketDefinition" + ">\n");
        VWWorkBasketDefinition[] workBasketList = this.getWorkBasketDefinitions();
        if (workBasketList != null && workBasketList.length > 0) {
            for (int i = 0; i < workBasketList.length; ++i) {
                if (workBasketList[i] == null) continue;
                workBasketList[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfInBasketDefinition" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfIndexDefinition" + ">\n");
        VWIndexDefinition[] indexList = this.getIndexes();
        if (indexList != null && indexList.length > 0) {
            for (int i = 0; i < indexList.length; ++i) {
                indexList[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfIndexDefinition" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfOperationDefinition" + ">\n");
        VWOperationDefinition[] opList = this.getOperations();
        if (opList != null && opList.length > 0) {
            for (int i = 0; i < opList.length; ++i) {
                opList[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfOperationDefinition" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "ReadSecurity" + ">\n");
        String[] rSecurityList = this.getReadSecurity();
        if (rSecurityList != null && rSecurityList.length > 0) {
            for (int i = 0; i < rSecurityList.length; ++i) {
                theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(rSecurityList[i]) + "</" + "Value" + ">\n");
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ReadSecurity" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "WriteSecurity" + ">\n");
        String[] wSecurityList = this.getWriteSecurity();
        if (wSecurityList != null && wSecurityList.length > 0) {
            for (int i = 0; i < wSecurityList.length; ++i) {
                theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(wSecurityList[i]) + "</" + "Value" + ">\n");
            }
        }
        theBuffer.append(INDENT_1 + "</" + "WriteSecurity" + ">\n");
        VWAttributeInfo theAttributeInfo = this.getAttributeInfo();
        theAttributeInfo.toXML(theBuffer, INDENT_1);
        theBuffer.append(INDENT_0 + "</" + "QueueDefinition" + ">\n");
    }

    public boolean hasChanged() throws VWException {
        return super.hasChanged();
    }

    protected void setHasChanged(boolean theNewValue) throws VWException {
        super.setHasChanged(theNewValue);
    }

    public static VWExposedFieldDefinition[] optionalSystemFields() throws VWException {
        return VWTableDefinition.optionalSystemFields(2);
    }

    public static String getLocalizedString(int theQueueType) throws VWException {
        if (!VWQueueDefinition.isValid(theQueueType)) {
            throw new VWException("vw.api.VWQueueDefTypeBadInteger", "Integer form of the queue type is invalid: {0}", String.valueOf(theQueueType));
        }
        return LocalizedStrings[theQueueType - 1];
    }

    public static boolean isValid(int theQueueType) {
        return theQueueType >= 1 && theQueueType <= 3;
    }

    public boolean hasFieldName(String fieldName) throws VWException {
        return super.hasFieldName(fieldName);
    }

    public Object clone() {
        int i;
        VWQueueDefinition queueDef = (VWQueueDefinition)super.clone();
        if (this.operations != null) {
            queueDef.operations = new VWOperationDefinition[this.operations.length];
            for (int i2 = 0; i2 < this.operations.length; ++i2) {
                if (this.operations[i2] == null) continue;
                queueDef.operations[i2] = (VWOperationDefinition)this.operations[i2].clone();
                queueDef.operations[i2].myQueue = queueDef;
            }
        }
        queueDef.operationsHandler = (VWArrayHandler)this.operationsHandler.clone();
        try {
            queueDef.m_workBasketDefHandler = new VWArrayHandler();
            queueDef.m_workBasketDefs = new VWWorkBasketDefinition[0];
            if (this.m_workBasketDefs != null) {
                VWWorkBasketDefinition workBasketDef = null;
                for (i = 0; i < this.m_workBasketDefs.length; ++i) {
                    if (this.m_workBasketDefs[i] == null) continue;
                    workBasketDef = (VWWorkBasketDefinition)this.m_workBasketDefs[i].clone();
                    workBasketDef.setMyQueueDefinition(queueDef);
                    queueDef.m_workBasketDefs = (VWWorkBasketDefinition[])queueDef.m_workBasketDefHandler.addElementToArray(queueDef.m_workBasketDefs, workBasketDef);
                }
            }
        }
        catch (VWException ex) {
            // empty catch block
        }
        try {
            queueDef.m_deletedWorkBasketDefHandler = new VWArrayHandler();
            queueDef.m_deletedWorkBasketDefs = new VWWorkBasketDefinition[0];
            if (this.m_deletedWorkBasketDefs != null) {
                VWWorkBasketDefinition workBasketDef = null;
                for (i = 0; i < this.m_deletedWorkBasketDefs.length; ++i) {
                    if (this.m_deletedWorkBasketDefs[i] == null) continue;
                    workBasketDef = (VWWorkBasketDefinition)this.m_deletedWorkBasketDefs[i].clone();
                    workBasketDef.setMyQueueDefinition(queueDef);
                    queueDef.m_deletedWorkBasketDefs = (VWWorkBasketDefinition[])queueDef.m_deletedWorkBasketDefHandler.addElementToArray(queueDef.m_deletedWorkBasketDefs, workBasketDef);
                }
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return queueDef;
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributes) throws VWException {
        super.setAttributeInfo(theAttributes);
    }

    public boolean getIsConnectorQueue() {
        return this.isConnectorQueue;
    }

    public void setIsConnectorQueue(boolean isConnectorQueue) {
        this.isConnectorQueue = isConnectorQueue;
    }

    protected void initWorkBasketsFromOrb() throws VWException {
        VWWorkBasketDefinition[] wbDefs = this.getWorkBasketDefinitions();
        if (wbDefs != null && wbDefs.length > 0) {
            for (int i = 0; i < wbDefs.length; ++i) {
                if (wbDefs[i] == null) continue;
                wbDefs[i].setMyQueueDefinition(this);
                wbDefs[i].initWorkBasketFromOrb();
            }
        }
    }

    protected void setSystemConfiguration(VWSystemConfiguration sysConfigObj) {
        this.sysConfig = sysConfigObj;
    }
}

